<?php

use App\Models\Hadiah;
use App\Models\Keranjang;
use App\Models\Kurir;
use App\Models\Member;
use App\Models\Modul;
use App\Models\Ongkirmember;
use App\Models\Pembayaran;
use App\Models\Poinbelanja;
use App\Models\Produk;
use App\Models\Rolepengeluaran;
use App\Models\Stok;
use App\Models\Transaksi;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Surfsidemedia\Shoppingcart\Facades\Cart;

if (!function_exists('tgl_indo')) {
    function tgl_indo($date)
    {
        // date_default_timezone_set('Asia/Jakarta');
        // array hari dan bulan
        $Hari = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu");
        $Bulan = array("Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember");

        // pemisahan tahun, bulan, hari, dan waktu
        $tahun = substr($date, 0, 4);
        $bulan = substr($date, 5, 2);
        $tgl = substr($date, 8, 2);
        $waktu = substr($date, 11, 5);
        $hari = date("w", strtotime($date));
        $result = $tgl . " " . $Bulan[(int)$bulan - 1] . " " . $tahun;

        return $result;
    }
}

if (!function_exists('tgl_time')) {
    function tgl_time($date)
    {
        date_default_timezone_set('Asia/Jakarta');
        // array hari dan bulan
        $Hari = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu");
        $Bulan = array("Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember");

        // pemisahan tahun, bulan, hari, dan waktu
        $tahun = substr($date, 0, 4);
        $bulan = substr($date, 5, 2);
        $tgl = substr($date, 8, 2);
        $waktu = substr($date, 11, 5);
        $hari = date("w", strtotime($date));
        $result = $Hari[$hari] . ", " . $tgl . " " . $Bulan[(int)$bulan - 1] . " " . $tahun . " " . $waktu;

        return $result;
    }
}

if (!function_exists('tgl_inf')) {
    function tgl_inf($date)
    {
        date_default_timezone_set('Asia/Jakarta');
        $ts = strtotime($date);
        $tsYmdDate = strtotime(date('Y-m-d 00:00:00', $ts));

        $tsNow = time();
        // $dateNow = date('Y-m-d H:i:s', $tsNow);
        $tsYmdNow = strtotime(date('Y-m-d 00:00:00', $tsNow));

        $diff = ($tsYmdNow - $tsYmdDate) / (60 * 60 * 24);

        if ($diff == '1') {

            return "Kemarin jam " . date('g:i A', $ts);
        } else {

            $diff = abs($tsNow - $ts);

            $seconds  = $diff;
            $minutes  = floor($diff / 60);
            $hours    = floor($minutes / 60);
            $days     = floor($hours / 24);

            if ($seconds < 60) {
                return "$seconds detik yang lalu";
            } elseif ($minutes < 60) {
                return ($minutes == 1) ? "semenit yang lalu" : "$minutes menit yang lalu";
            } elseif ($hours < 24) {
                return ($hours == 1) ? "satu jam yang lalu" : "$hours jam yang lalu";
            } else {
                return tgl_time($date);
            }
        }
    }
}

if (!function_exists('format_bulan')) {
    function format_bulan($date)
    {
        // date_default_timezone_set('Asia/Jakarta');
        // array hari dan bulan
        $Hari = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu");
        $Bulan = array("JAN", "FEB", "MAR", "APR", "MEI", "JUN", "JUL", "AGU", "SEP", "OKT", "NOV", "DES");

        // pemisahan tahun, bulan, hari, dan waktu
        $tahun = substr($date, 0, 4);
        $bulan = substr($date, 5, 2);
        $tgl = substr($date, 8, 2);
        $waktu = substr($date, 11, 5);
        $hari = date("w", strtotime($date));
        $result = $Bulan[(int)$bulan - 1];

        return $result;
    }
}


if (!function_exists('kodemember')) {
    function kodemember()
    {
        $k = Member::orderBy('id', 'DESC')->limit(1)->first();
        if (empty($k->kd_member)) {
            $inf_kode = 1;
        } else {
            $no =  substr($k->kd_member, 4);
            $inf_kode = intval($no) + 1;
        }
        $batas = str_pad($inf_kode, 5, "0", STR_PAD_LEFT);
        $kode = date('my') . $batas;
        return  $kode;
    }
}

if (!function_exists('kodetransaksi')) {
    function kodetransaksi()
    {
        $k = Transaksi::orderBy('id', 'DESC')->limit(1)->first();
        if (empty($k->kd_transaksi)) {
            $inf_kode = 1;
        } else {
            $no =  substr($k->kd_transaksi, 4);
            $inf_kode = intval($no) + 1;
        }
        $batas = str_pad($inf_kode, 5, "0", STR_PAD_LEFT);
        $kode =  date('my') . $batas;
        return  $kode;
    }
}

if (!function_exists('kodepengeluaran')) {
    function kodepengeluaran()
    {
        $k = Rolepengeluaran::orderBy('id', 'DESC')->limit(1)->first();
        if (empty($k->kd_pengeluaran)) {
            $inf_kode = 1;
        } else {
            $no =  substr($k->kd_pengeluaran, 4);
            $inf_kode = intval($no) + 1;
        }
        $batas = str_pad($inf_kode, 5, "0", STR_PAD_LEFT);
        $kode =  date('my') . $batas;
        return  $kode;
    }
}

if (!function_exists('getClientIP')) {
    function getClientIP()
    {
        if (isset($_SERVER)) {

            if (isset($_SERVER["HTTP_X_FORWARDED_FOR"]))
                return $_SERVER["HTTP_X_FORWARDED_FOR"];

            if (isset($_SERVER["HTTP_CLIENT_IP"]))
                return $_SERVER["HTTP_CLIENT_IP"];

            return $_SERVER["REMOTE_ADDR"];
        }

        if (getenv('HTTP_X_FORWARDED_FOR'))
            return getenv('HTTP_X_FORWARDED_FOR');

        if (getenv('HTTP_CLIENT_IP'))
            return getenv('HTTP_CLIENT_IP');

        return getenv('REMOTE_ADDR');
    }
}

if (!function_exists('tahun')) {
    function tahun()
    {
        $t = Transaksi::selectRaw("YEAR(created_at) as thn")
            ->groupBy(DB::raw("YEAR(created_at)"))
            ->get();
        return $t;
    }
}

if (!function_exists('stok')) {
    function stok($id)
    {
        $s = Stok::where('produk_id', $id)->selectRaw('SUM(jml_masuk) as jml')->groupBy('produk_id')->first();
        return (empty($s->jml)) ? 0 : $s->jml;
    }
}

if (!function_exists('terjual')) {
    function terjual($id)
    {
        $k = Keranjang::where('produk_id', $id)->selectRaw('SUM(jumlah) as jml')->groupBy('produk_id')->first();
        return (empty($k->jml)) ? 0 : $k->jml;
    }
}

if (!function_exists('belanja')) {
    function belanja($id)
    {
        $jml = Transaksi::where('member_id', $id)->count();
        return $jml;
    }
}

if (!function_exists('item')) {
    function item($id)
    {
        $jml = Keranjang::where('transaksi_id', $id)->selectRaw('SUM(jumlah) as jml')->groupBy('transaksi_id')->first();
        return $jml;
    }
}

if (!function_exists('produk')) {
    function produk($id)
    {
        $produk = Produk::where('id', $id)->first();
        return $produk;
    }
}


if (!function_exists('diskon')) {
    function diskon()
    {
        $d = Modul::where('kode', 'DISC')->where('status', 'Y')->first();
        if (!empty($d)) {
            $tgl1 = date('Y-m-d', strtotime($d->tgl1));
            $tgl2 = date('Y-m-d', strtotime($d->tgl2));

            $tanggal_1 = date_create($tgl1);
            $tanggal_2 = date_create($tgl2);

            $hariini = date_create();

            $selisihdiskon  = date_diff($tanggal_1, $tanggal_2);
            $jmlhrdis = $selisihdiskon->days;

            $selisihari  = date_diff($tanggal_1, $hariini);
            $jmlhrini = $selisihari->days;

            if ($jmlhrdis >=  $jmlhrini) {
                $dis = $d->isi;
            } else if ($jmlhrdis <  $jmlhrini) {
                $dis = 0;
            }
        } else {
            $dis = 0;
        }
        return $dis;
    }

    if (!function_exists('modull')) {
        function modull($kode)
        {
            $m = Modul::where('kode', $kode)->first();
            return $m;
        }
    }

    if (!function_exists('poinmasuk')) {
        function poinmasuk($id)
        {
            $m = Poinbelanja::where('member_id', $id)->where('sts_poin', 'M')->selectRaw('SUM(jml_poin) as jml')->groupBy('member_id')->first();
            return (empty($m->jml)) ? 0 : $m->jml;
        }
    }

    if (!function_exists('poinkeluar')) {
        function poinkeluar($id)
        {
            $m = Poinbelanja::where('member_id', $id)->where('sts_poin', 'K')->selectRaw('SUM(jml_poin) as jml')->groupBy('member_id')->first();
            return (empty($m->jml)) ? 0 : $m->jml;
        }
    }

    if (!function_exists('poinbaru')) {
        function poinbaru($kode)
        {
            $m = Poinbelanja::where('kodetran', $kode)->first();
            return (empty($m->jml)) ? 0 : $m->jml;
        }
    }

    if (!function_exists('stok_item')) {
        function stok_item($id)
        {
            $jml = Poinbelanja::where('kodetran', $id)->count();
            return (empty($jml)) ? 0 : $jml;
        }
    }

    if (!function_exists('hadiah')) {
        function hadiah($id)
        {
            $hadiah = Hadiah::where('kd_hadiah', $id)->first();
            return  $hadiah;
        }
    }

    if (!function_exists('ongkir')) {
        function ongkir($id)
        {
            $ongkir = Ongkirmember::where('member_id', $id)->first();
            return  $ongkir;
        }
    }

    if (!function_exists('kurir')) {
        function kurir($id)
        {
            $kurir = Kurir::where('transaksi_id', $id)->first();
            return (empty($kurir)) ? '' : $kurir;
        }
    }

    if (!function_exists('pembayaran')) {
        function pembayaran()
        {
            $p = Pembayaran::where('sts_transfer', 'T');
            return $p;
        }
    }

    if (!function_exists('konfirmasi')) {
        function konfirmasi()
        {
            $p = Pembayaran::where('sts_transfer', 'T')->count();
            return $p;
        }
    }

    if (!function_exists('poinbaru')) {
        function poinbaru($kode)
        {
            $p = Poinbelanja::where('kodetran', $kode)->first();
            return (empty($p)) ? 0 : $p->jml_poin;
        }
    }

    if (!function_exists('cek_pengiriman')) {
        function cek_pengiriman()
        {
            $jmlt = Transaksi::where('sts_antar', 'Y')->where('user_id', Auth::user()->id)->count();
            $ttlt = (empty($jmlt)) ? 0 : $jmlt;
            $jmlk = Kurir::join('transaksis', 'transaksis.id', '=', 'kurirs.transaksi_id')->where('user_id', Auth::user()->id)->count();
            $ttlk = (empty($jmlk)) ? 0 : $jmlk;
            return  $ttlt - $ttlk;
        }
    }

    if (!function_exists('printer_cek')) {
        function printer_cek($kata, $data)
        {
            $jml = strlen($kata . $data);

            if ($jml == 5) {
                // 27 spasi
                return $kata . "                           " . $data;
            } else if ($jml == 6) {
                // 26 spasi
                return $kata . "                          " . $data;
            } else if ($jml == 7) {
                // 25 spasi
                return $kata . "                         " . $data;
            } else if ($jml == 8) {
                // 24 spasi
                return $kata . "                        " . $data;
            } else if ($jml == 9) {
                // 23 spasi
                return $kata . "                       " . $data;
            } else if ($jml == 10) {
                // 22 spasi
                return $kata . "                      " . $data;
            } else if ($jml == 11) {
                // 21 spasi
                return $kata . "                     " . $data;
            } else if ($jml == 12) {
                // 20 spasi
                return $kata . "                    " . $data;
            } else if ($jml == 13) {
                // 19 spasi
                return $kata . "                   " . $data;
            } else if ($jml == 14) {
                // 18 spasi
                return $kata . "                  " . $data;
            } else if ($jml == 15) {
                // 17 spasi
                return $kata . "                 " . $data;
            } else if ($jml == 16) {
                // 16 spasi
                return $kata . "                " . $data;
            } else if ($jml == 17) {
                // 15 spasi
                return $kata . "               " . $data;
            } else if ($jml == 18) {
                // 14 spasi
                return $kata . "              " . $data;
            } else if ($jml == 19) {
                // 13 spasi
                return $kata . "             " . $data;
            } else if ($jml == 20) {
                // 12 spasi
                return $kata . "            " . $data;
            } else if ($jml == 21) {
                // 11 spasi
                return $kata . "           " . $data;
            } else if ($jml == 22) {
                // 10 spasi
                return $kata . "          " . $data;
            } else if ($jml == 23) {
                // 9 spasi
                return $kata . "         " . $data;
            } else if ($jml == 24) {
                // 8 spasi
                return $kata . "        " . $data;
            } else if ($jml == 25) {
                // 7 spasi
                return $kata . "       " . $data;
            } else if ($jml == 26) {
                // 6 spasi
                return $kata . "      " . $data;
            } else if ($jml == 27) {
                // 5 spasi
                return $kata . "     " . $data;
            } else if ($jml == 28) {
                // 4 spasi
                return $kata . "    " . $data;
            } else if ($jml == 29) {
                // 3 spasi
                return $kata . "   " . $data;
            } else if ($jml == 30) {
                // 2 spasi
                return $kata . "  " . $data;
            } else if ($jml == 31) {
                // 1 spasi
                return $kata . " " . $data;
            }
        }
    }
}
